/** @file   RocketBullet.cpp
 * @brief   Implementation of RocketBullet class.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/06/21 16:10:10 $
 * @author  Tomi Lamminsaari
 */

#include "RocketBullet.h"
#include "www_map.h"
#include "gameanims.h"
#include "bullettable.h"
#include "animplayer.h"
#include "soundsamples.h"
#include "AnimId.h"
#include "Settings.h"
using namespace eng2d;


namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
RocketBullet::RocketBullet( GameObject* aShooter, const Vec2D& aPos ) :
  Bullet( aShooter, Bullet::ERocketLauncher, aPos )
{
  // Set the animation.
  iAnimation = GameAnims::findAnimation( AnimId::KBulletRocket );
}



/** Destructor.
 */
RocketBullet::~RocketBullet()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Draws this bullet.
 */
void RocketBullet::redraw( BITMAP* aBitmap ) const
{
  int x = iPosition.intX() - Map::scrollX;
  int y = iPosition.intY() - Map::scrollY;
  BITMAP* bulletGfx = iAnimation.currentFrame().asBitmap();
  x -= bulletGfx->w / 2;
  y -= bulletGfx->h / 2;
  rotate_sprite( aBitmap, bulletGfx, x,y, itofix(iRotation) );
}



/** Explodes this rocket.
 */
void RocketBullet::endingActions( BulletTable* aBulletTable )
{
  // First we undo the previous movement.
  iPosition -= iVelocity;
  
  // Then we spawn the fragments.
  Weapon w = Bullet::bullet2Weapon( iType );
  float angle = 0;
  float angleStep = 256.0 / 32.0;
  for ( int i=0; i < 32; i++ ) {
    Bullet* bullet = BulletTable::createBullet( 0, iPosition, Bullet::EGrenade );
    Vec2D mvec( 0, w.velocity() );
    mvec.rotate( angle );
    bullet->setVelocity( mvec );
    aBulletTable->spawnBullet( bullet );
    
    angle += angleStep;
  }
  const Animation& anim = GameAnims::findAnimation( AnimId::KExplosionGrenade );
  AnimPlayer::spawn( anim, iPosition, 0 );
  const Animation& lightAnim = GameAnims::findAnimation( AnimId::KGrenadeExplosionLight );
  if ( Settings::explosionLights == true ) {
    AnimPlayer::spawn( lightAnim, iPosition, 0 );
  }
  Sound::playSample( SMP_GRENADE, false );
}

};  // end of namespace
